// Listing 10-14

import java.io.*;
import java.util.Scanner;

public class Listing10_14
{
   public static void main(String[] args) throws IOException
   {
      // Drukujemy nagłówek raportu
      printHeader();
      
      // Drukujemy treść raportu
      printDetails();
   }

   // Metoda printHeader drukuje nagłówek raportu
   public static void printHeader()
   {
      System.out.println("Raport ze zbiórki pieniędzy w Akademii Handlowej\n");
      System.out.println("Ident. studenta            Kwota");
      System.out.println("======================================");
   }

   // Metoda printDetails drukuje treść raportu
   public static void printDetails() throws IOException
   {
      // Zmienne przeznaczone na pola rekordu
      int studentID;
      double donation;
      
      // Zmienne pełniące role akumulatorów
      double studentTotal = 0;
      double total = 0;
      
      // Flaga dla pierwszego rekordu
      boolean firstRecord = true;
      
      // Zmienna, którą wykorzystamy w mechanizmie
      // separatora sterowania
      int currentID = 0;
      
      // Deklarujemy plik wejściowy i otwieramy go
      Scanner donationsFile = new Scanner(new File("donations.dat"));
      
      // UWAGA: Ponieważ za pomocą obiektu Scanner można sprawdzić
      // czy z pliku można odczytać kolejny element,
      // proces odczytywania danych z pliku i drukowania ich
      // różni się w tym programie od pseudokodu przedstawionego w książce
      
      // Drukujemy treść raportu
      while (donationsFile.hasNext())
      {
         // Odczytujemy rekord
         studentID = donationsFile.nextInt();
         donation = donationsFile.nextDouble();
         
         // Sprawdzamy, czy jest to pierwszy rekord
         if (firstRecord)
         {
            currentID = studentID;
            firstRecord = false;
         }
         
         // Sprawdzamy, czy zmieniła się wartość
         // w polu studentID
         if (studentID != currentID)
         {
            // Drukujemy sumę wpłat zebranych przez studenta,
            // a następnie pustą linię
            System.out.printf("Suma wpłat zebranych przez studenta: %,.2f zł\n\n",
                               studentTotal);
            
            // Zapisujemy identyfikator kolejnego studenta
            currentID = studentID;
            
            // Zerujemy wartość akumulatora
            studentTotal = 0;
         }
         
         // Drukujemy informacje dotyczące wpłat
         System.out.printf("%d               %,.2f zł\n", studentID, donation);
         
         // Aktualizujemy wartości akumulatorów
         studentTotal = studentTotal + donation;
         total = total + donation;
         
      } // koniec pętli while
      
      // Drukujemy sumę wpłat zebranych przez ostatniego studenta,
      // a następnie pustą linię
      System.out.printf("Suma wpłat zebranych przez studenta: %,.2f zł\n\n",
                         studentTotal);
         
      // Drukujemy sumę wszystkich wpłat
      System.out.printf("Suma wszystkich wpłat: %,.2f zł\n", total);
      
      // Zamykamy plik
      donationsFile.close();
   }
}